// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "oparray.h"

template<class pOpfunc>
OpArray<pOpfunc>::OpArray(DWORD s, DWORD e) : start(s), end(e), arr(2 << (e - s)) {
  DWORD i;

  mask = makemask(start, end);

  DEGUB(df, "Array created. mask=%08X  size=%i\n", mask, arr.size());

  for(i=0; i<arr.size(); i++)
    arr[i] = NULL;
}

//See notes.txt for opcode explanation
#define OPCODE(pri, sec) ((pri << 26) | (sec << 1))

template<class pOpfunc>
void OpArray<pOpfunc>::addOpcode(pOpfunc f, const char *a, DWORD pri, DWORD sm, DWORD sec) {
  DWORD opcode = OPCODE(pri, sec);
  DWORD num = getNum(opcode);

  DEGUB(df, "Adding %s (%i, %i, %i)  num=%i\n", a, pri, sm, sec, num);

  if(arr[num] == NULL) {
    if(start == sm) {
      arr[num] = new Opcode(f, a);
    } else {
      OpArray *temp;
      if(start == 0) {
	arr[num] = temp = new OpArray(sm, 30);
	temp->addOpcode(f, a, pri, sm, sec);
      } else if(start > sm) {
	arr[num] = temp = new OpArray(sm, start-1);
	temp->addOpcode(f, a, pri, sm, sec);
      } else if(start < sm) {
	//BFE("Not implemented!");
	DWORD i, j, divider = 1 << (sm - start), multiplier = 0x80000000 >> sm;
	Array<OpcodeBase *> temparr(0);
	temparr.steal(arr);

	arr.resize(2 << (end - sm));
	for(i=0; i<arr.size(); i++)
	  arr[i] = NULL;

	for(i=0; i<arr.size(); i++) {
	  temp = NULL;
	  for(j=0; j<divider; j++) {
	    if(!temp && temparr[j * multiplier + i])
	      arr[i] = temp = new OpArray(start, sm-1);
	    if(temp)
	      temp->arr[j] = temparr[j * multiplier + i];
	  }
	}

	start = sm;
	mask = makemask(start, end);
	addOpcode(f, a, pri, sm, sec);
      }	
    }
  } else {
    if(arr[num]->isArray()) {
      MAKEP(OpArray, arr[num])->addOpcode(f, a, pri, sm, sec);
    } else {
      BFE("Opcode array init error");
    }
  }
}

template<class pOpfunc>
OpArray<pOpfunc>::~OpArray() {
  for(DWORD i=0; i<arr.size(); i++)
    if(arr[i])
      delete arr[i];
}

template<class pOpfunc>
pOpfunc OpArray<pOpfunc>::getOpFunc(DWORD opcode) const {
  DWORD num = getNum(opcode);
  if(arr[num])
    return arr[num]->getOpFunc(opcode);
  else
    return NULL;
}
template<class pOpfunc>
const char *OpArray<pOpfunc>::getOpAsm(DWORD opcode) const {
  DWORD num = getNum(opcode);
  if(arr[num])
    return arr[num]->getOpAsm(opcode);
  else
    return NULL;
}
